package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTogo: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇬",
        description = "flag: Togo",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-togo", "togo-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Togo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTogo: Emoji get() = _FlagTogo

/**
 * Alias to emoji [FlagTogo] (Flags: country-flag: flag: Togo).
*/
public val Emoji.Companion.TogoFlag: Emoji get() = _FlagTogo
