package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BalanceScale: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚖️",
        description = "balance scale",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("balance-scale", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: tool: balance scale.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BalanceScale: Emoji get() = _BalanceScale
