package org.kodein.emoji.people_body.person_fantasy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonFantasy() {
    add(intArrayOf(0x1f9dc), _Merperson)
    addVariations(intArrayOf(0x1f9dc, 0x0), _Merperson, 1)
    add(intArrayOf(0x1f9da), _Fairy)
    addVariations(intArrayOf(0x1f9da, 0x0), _Fairy, 1)
    add(intArrayOf(0x1f9de), _Genie)
    add(intArrayOf(0x1f9dd), _Elf)
    addVariations(intArrayOf(0x1f9dd, 0x0), _Elf, 1)
    add(intArrayOf(0x1f9d9), _Mage)
    addVariations(intArrayOf(0x1f9d9, 0x0), _Mage, 1)
    add(intArrayOf(0x1f9db), _Vampire)
    addVariations(intArrayOf(0x1f9db, 0x0), _Vampire, 1)
    add(intArrayOf(0x1f9df), _Zombie)
    add(intArrayOf(0x1f9cc), _Troll)
    add(intArrayOf(0x1f9b8), _Superhero)
    addVariations(intArrayOf(0x1f9b8, 0x0), _Superhero, 1)
    add(intArrayOf(0x1f9b9), _Supervillain)
    addVariations(intArrayOf(0x1f9b9, 0x0), _Supervillain, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f384), _MxClaus)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f384), _MxClaus, 1)
    add(intArrayOf(0x1f47c), _BabyAngel)
    addVariations(intArrayOf(0x1f47c, 0x0), _BabyAngel, 1)
    add(intArrayOf(0x1f385), _SantaClaus)
    addVariations(intArrayOf(0x1f385, 0x0), _SantaClaus, 1)
    add(intArrayOf(0x1f936), _MrsClaus)
    addVariations(intArrayOf(0x1f936, 0x0), _MrsClaus, 1)
    add(intArrayOf(0x1f9b8, 0x200d, 0x2642), _ManSuperhero)
    addVariations(intArrayOf(0x1f9b8, 0x0, 0x200d, 0x2642), _ManSuperhero, 1)
    add(intArrayOf(0x1f9b8, 0x200d, 0x2642, 0xfe0f), _ManSuperhero)
    addVariations(intArrayOf(0x1f9b8, 0x0, 0x200d, 0x2642, 0xfe0f), _ManSuperhero, 1)
    add(intArrayOf(0x1f9b8, 0x200d, 0x2640), _WomanSuperhero)
    addVariations(intArrayOf(0x1f9b8, 0x0, 0x200d, 0x2640), _WomanSuperhero, 1)
    add(intArrayOf(0x1f9b8, 0x200d, 0x2640, 0xfe0f), _WomanSuperhero)
    addVariations(intArrayOf(0x1f9b8, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanSuperhero, 1)
    add(intArrayOf(0x1f9b9, 0x200d, 0x2642), _ManSupervillain)
    addVariations(intArrayOf(0x1f9b9, 0x0, 0x200d, 0x2642), _ManSupervillain, 1)
    add(intArrayOf(0x1f9b9, 0x200d, 0x2642, 0xfe0f), _ManSupervillain)
    addVariations(intArrayOf(0x1f9b9, 0x0, 0x200d, 0x2642, 0xfe0f), _ManSupervillain, 1)
    add(intArrayOf(0x1f9b9, 0x200d, 0x2640), _WomanSupervillain)
    addVariations(intArrayOf(0x1f9b9, 0x0, 0x200d, 0x2640), _WomanSupervillain, 1)
    add(intArrayOf(0x1f9b9, 0x200d, 0x2640, 0xfe0f), _WomanSupervillain)
    addVariations(intArrayOf(0x1f9b9, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanSupervillain, 1)
    add(intArrayOf(0x1f9d9, 0x200d, 0x2642), _ManMage)
    addVariations(intArrayOf(0x1f9d9, 0x0, 0x200d, 0x2642), _ManMage, 1)
    add(intArrayOf(0x1f9d9, 0x200d, 0x2642, 0xfe0f), _ManMage)
    addVariations(intArrayOf(0x1f9d9, 0x0, 0x200d, 0x2642, 0xfe0f), _ManMage, 1)
    add(intArrayOf(0x1f9d9, 0x200d, 0x2640), _WomanMage)
    addVariations(intArrayOf(0x1f9d9, 0x0, 0x200d, 0x2640), _WomanMage, 1)
    add(intArrayOf(0x1f9d9, 0x200d, 0x2640, 0xfe0f), _WomanMage)
    addVariations(intArrayOf(0x1f9d9, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanMage, 1)
    add(intArrayOf(0x1f9da, 0x200d, 0x2642), _ManFairy)
    addVariations(intArrayOf(0x1f9da, 0x0, 0x200d, 0x2642), _ManFairy, 1)
    add(intArrayOf(0x1f9da, 0x200d, 0x2642, 0xfe0f), _ManFairy)
    addVariations(intArrayOf(0x1f9da, 0x0, 0x200d, 0x2642, 0xfe0f), _ManFairy, 1)
    add(intArrayOf(0x1f9da, 0x200d, 0x2640), _WomanFairy)
    addVariations(intArrayOf(0x1f9da, 0x0, 0x200d, 0x2640), _WomanFairy, 1)
    add(intArrayOf(0x1f9da, 0x200d, 0x2640, 0xfe0f), _WomanFairy)
    addVariations(intArrayOf(0x1f9da, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanFairy, 1)
    add(intArrayOf(0x1f9db, 0x200d, 0x2642), _ManVampire)
    addVariations(intArrayOf(0x1f9db, 0x0, 0x200d, 0x2642), _ManVampire, 1)
    add(intArrayOf(0x1f9db, 0x200d, 0x2642, 0xfe0f), _ManVampire)
    addVariations(intArrayOf(0x1f9db, 0x0, 0x200d, 0x2642, 0xfe0f), _ManVampire, 1)
    add(intArrayOf(0x1f9db, 0x200d, 0x2640), _WomanVampire)
    addVariations(intArrayOf(0x1f9db, 0x0, 0x200d, 0x2640), _WomanVampire, 1)
    add(intArrayOf(0x1f9db, 0x200d, 0x2640, 0xfe0f), _WomanVampire)
    addVariations(intArrayOf(0x1f9db, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanVampire, 1)
    add(intArrayOf(0x1f9dc, 0x200d, 0x2642), _Merman)
    addVariations(intArrayOf(0x1f9dc, 0x0, 0x200d, 0x2642), _Merman, 1)
    add(intArrayOf(0x1f9dc, 0x200d, 0x2642, 0xfe0f), _Merman)
    addVariations(intArrayOf(0x1f9dc, 0x0, 0x200d, 0x2642, 0xfe0f), _Merman, 1)
    add(intArrayOf(0x1f9dc, 0x200d, 0x2640), _Mermaid)
    addVariations(intArrayOf(0x1f9dc, 0x0, 0x200d, 0x2640), _Mermaid, 1)
    add(intArrayOf(0x1f9dc, 0x200d, 0x2640, 0xfe0f), _Mermaid)
    addVariations(intArrayOf(0x1f9dc, 0x0, 0x200d, 0x2640, 0xfe0f), _Mermaid, 1)
    add(intArrayOf(0x1f9dd, 0x200d, 0x2642), _ManElf)
    addVariations(intArrayOf(0x1f9dd, 0x0, 0x200d, 0x2642), _ManElf, 1)
    add(intArrayOf(0x1f9dd, 0x200d, 0x2642, 0xfe0f), _ManElf)
    addVariations(intArrayOf(0x1f9dd, 0x0, 0x200d, 0x2642, 0xfe0f), _ManElf, 1)
    add(intArrayOf(0x1f9dd, 0x200d, 0x2640), _WomanElf)
    addVariations(intArrayOf(0x1f9dd, 0x0, 0x200d, 0x2640), _WomanElf, 1)
    add(intArrayOf(0x1f9dd, 0x200d, 0x2640, 0xfe0f), _WomanElf)
    addVariations(intArrayOf(0x1f9dd, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanElf, 1)
    add(intArrayOf(0x1f9de, 0x200d, 0x2642), _ManGenie)
    add(intArrayOf(0x1f9de, 0x200d, 0x2642, 0xfe0f), _ManGenie)
    add(intArrayOf(0x1f9de, 0x200d, 0x2640), _WomanGenie)
    add(intArrayOf(0x1f9de, 0x200d, 0x2640, 0xfe0f), _WomanGenie)
    add(intArrayOf(0x1f9df, 0x200d, 0x2642), _ManZombie)
    add(intArrayOf(0x1f9df, 0x200d, 0x2642, 0xfe0f), _ManZombie)
    add(intArrayOf(0x1f9df, 0x200d, 0x2640), _WomanZombie)
    add(intArrayOf(0x1f9df, 0x200d, 0x2640, 0xfe0f), _WomanZombie)
}

internal fun MutableList<Emoji>.addAllPersonFantasy() {
    add(_Merperson)
    add(_Fairy)
    add(_Genie)
    add(_Elf)
    add(_Mage)
    add(_Vampire)
    add(_Zombie)
    add(_Troll)
    add(_Superhero)
    add(_Supervillain)
    add(_MxClaus)
    add(_BabyAngel)
    add(_SantaClaus)
    add(_MrsClaus)
    add(_ManSuperhero)
    add(_WomanSuperhero)
    add(_ManSupervillain)
    add(_WomanSupervillain)
    add(_ManMage)
    add(_WomanMage)
    add(_ManFairy)
    add(_WomanFairy)
    add(_ManVampire)
    add(_WomanVampire)
    add(_Merman)
    add(_Mermaid)
    add(_ManElf)
    add(_WomanElf)
    add(_ManGenie)
    add(_WomanGenie)
    add(_ManZombie)
    add(_WomanZombie)
}

/**
 * All Emoji of the People & Body: person-fantasy subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPersonFantasy(): List<Emoji> =
    ArrayList<Emoji>(32).apply { addAllPersonFantasy() }
