package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonWearingTurban: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👳",
        description = "person wearing turban",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-wearing-turban", "turban"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: person wearing turban.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonWearingTurban: SkinTone1Emoji get() = _PersonWearingTurban

/**
 * Alias to emoji [PersonWearingTurban] (People & Body: person-role: person wearing turban).
*/
public val Emoji.Companion.Turban: SkinTone1Emoji get() = _PersonWearingTurban
