package org.kodein.emoji.people_body.person_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PeopleHugging: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫂",
        description = "people hugging",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("people-hugging", "hugging"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji People & Body: person-symbol: people hugging.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PeopleHugging: Emoji get() = _PeopleHugging

/**
 * Alias to emoji [PeopleHugging] (People & Body: person-symbol: people hugging).
*/
public val Emoji.Companion.Hugging: Emoji get() = _PeopleHugging
