package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpeechBalloon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💬",
        description = "speech balloon",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("speech-balloon", "speech-bubble"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: speech balloon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpeechBalloon: Emoji get() = _SpeechBalloon

/**
 * Alias to emoji [SpeechBalloon] (Smileys & Emotion: emotion: speech balloon).
*/
public val Emoji.Companion.SpeechBubble: Emoji get() = _SpeechBalloon
