package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ThinkingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤔",
        description = "thinking face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("thinking-face", ),
        emoticons = listOf("=L"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hand: thinking face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ThinkingFace: Emoji get() = _ThinkingFace
