package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithRollingEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🙄",
        description = "face with rolling eyes",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("face-with-rolling-eyes", "rolling-eyes"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: face with rolling eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithRollingEyes: Emoji get() = _FaceWithRollingEyes

/**
 * Alias to emoji [FaceWithRollingEyes] (Smileys & Emotion: face-neutral-skeptical: face with rolling eyes).
*/
public val Emoji.Companion.RollingEyes: Emoji get() = _FaceWithRollingEyes
