package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SlightlySmilingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🙂",
        description = "slightly smiling face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("slightly-smiling-face", "slightly-happy"),
        emoticons = listOf(":)", ":-)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: slightly smiling face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SlightlySmilingFace: Emoji get() = _SlightlySmilingFace

/**
 * Alias to emoji [SlightlySmilingFace] (Smileys & Emotion: face-smiling: slightly smiling face).
*/
public val Emoji.Companion.SlightlyHappy: Emoji get() = _SlightlySmilingFace
