package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BeatingHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💓",
        description = "beating heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("beating-heart", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: beating heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BeatingHeart: Emoji get() = _BeatingHeart
