package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DownRightArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "↘️",
        description = "down-right arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("down-right-arrow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: down-right arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DownRightArrow: Emoji get() = _DownRightArrow
