package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FastDownButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏬",
        description = "fast down button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("fast-down-button", "fast-down", "double-triangle-down"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: av-symbol: fast down button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FastDownButton: Emoji get() = _FastDownButton

/**
 * Alias to emoji [FastDownButton] (Symbols: av-symbol: fast down button).
*/
public val Emoji.Companion.FastDown: Emoji get() = _FastDownButton

/**
 * Alias to emoji [FastDownButton] (Symbols: av-symbol: fast down button).
*/
public val Emoji.Companion.DoubleTriangleDown: Emoji get() = _FastDownButton
