package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceSleepy() {
    add(intArrayOf(0x1f60c), _RelievedFace)
    add(intArrayOf(0x1f634), _SleepingFace)
    add(intArrayOf(0x1f62a), _SleepyFace)
    add(intArrayOf(0x1f924), _DroolingFace)
    add(intArrayOf(0x1f614), _PensiveFace)
}

internal fun MutableList<Emoji>.addAllFaceSleepy() {
    add(_RelievedFace)
    add(_SleepingFace)
    add(_SleepyFace)
    add(_DroolingFace)
    add(_PensiveFace)
}

/**
 * All Emoji of the Smileys & Emotion: face-sleepy subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceSleepy(): List<Emoji> =
    ArrayList<Emoji>(5).apply { addAllFaceSleepy() }
