package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CloudWithRain: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌧️",
        description = "cloud with rain",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("cloud-with-rain", "rain-cloud"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: cloud with rain.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CloudWithRain: Emoji get() = _CloudWithRain

/**
 * Alias to emoji [CloudWithRain] (Travel & Places: sky & weather: cloud with rain).
*/
public val Emoji.Companion.RainCloud: Emoji get() = _CloudWithRain
