package org.kodein.emoji.activities.award_medal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MilitaryMedal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎖️",
        description = "military medal",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("military-medal", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: award-medal: military medal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MilitaryMedal: Emoji get() = _MilitaryMedal
