package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MoonViewingCeremony: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎑",
        description = "moon viewing ceremony",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("moon-viewing-ceremony", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: event: moon viewing ceremony.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MoonViewingCeremony: Emoji get() = _MoonViewingCeremony
