package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBurkinaFaso: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇫",
        description = "flag: Burkina Faso",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-burkina-faso", "burkina-faso-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Burkina Faso.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBurkinaFaso: Emoji get() = _FlagBurkinaFaso

/**
 * Alias to emoji [FlagBurkinaFaso] (Flags: country-flag: flag: Burkina Faso).
*/
public val Emoji.Companion.BurkinaFasoFlag: Emoji get() = _FlagBurkinaFaso
