package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSouthAfrica: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇿🇦",
        description = "flag: South Africa",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-south-africa", "south-africa-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: South Africa.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSouthAfrica: Emoji get() = _FlagSouthAfrica

/**
 * Alias to emoji [FlagSouthAfrica] (Flags: country-flag: flag: South Africa).
*/
public val Emoji.Companion.SouthAfricaFlag: Emoji get() = _FlagSouthAfrica
