package org.kodein.emoji.objects.other_object

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllOtherObject() {
    add(intArrayOf(0x1f6ac), _Cigarette)
    add(intArrayOf(0x26b0, 0xfe0f), _Coffin)
    add(intArrayOf(0x26b0), _Coffin)
    add(intArrayOf(0x1faa6), _Headstone)
    add(intArrayOf(0x26b1, 0xfe0f), _FuneralUrn)
    add(intArrayOf(0x26b1), _FuneralUrn)
    add(intArrayOf(0x1f9ff), _NazarAmulet)
    add(intArrayOf(0x1faac), _Hamsa)
    add(intArrayOf(0x1f5ff), _Moai)
    add(intArrayOf(0x1faa7), _Placard)
    add(intArrayOf(0x1faaa), _IdentificationCard)
}

internal suspend fun SequenceScope<Emoji>.yieldAllOtherObject() {
    yield(_Cigarette)
    yield(_Coffin)
    yield(_Headstone)
    yield(_FuneralUrn)
    yield(_NazarAmulet)
    yield(_Hamsa)
    yield(_Moai)
    yield(_Placard)
    yield(_IdentificationCard)
}

internal val countOtherObject = 9

/**
 * All Emoji of the Objects: other-object subgroup.
*/
public fun Emoji.Companion.sequenceOtherObject(): Sequence<Emoji> =
    sequence { yieldAllOtherObject() }

/**
 * All Emoji of the Objects: other-object subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listOtherObject(): List<Emoji> =
    ArrayList<Emoji>(countOtherObject).also { list -> sequenceOtherObject().forEach { list.add(it) } }

@Deprecated("Renamed listOtherObject.", replaceWith = ReplaceWith("listOtherObject()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allOtherObject(): List<Emoji> =
    listOtherObject()
