package org.kodein.emoji.people_body.hands

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _FoldedHands: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙏",
        description = "folded hands",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("folded-hands", "please", "pray", "hope", "wish", "thank-you", "high-five"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hands: folded hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FoldedHands: SkinTone1Emoji get() = _FoldedHands

/**
 * Alias to emoji [FoldedHands] (People & Body: hands: folded hands).
*/
public val Emoji.Companion.Please: SkinTone1Emoji get() = _FoldedHands

/**
 * Alias to emoji [FoldedHands] (People & Body: hands: folded hands).
*/
public val Emoji.Companion.Pray: SkinTone1Emoji get() = _FoldedHands

/**
 * Alias to emoji [FoldedHands] (People & Body: hands: folded hands).
*/
public val Emoji.Companion.Hope: SkinTone1Emoji get() = _FoldedHands

/**
 * Alias to emoji [FoldedHands] (People & Body: hands: folded hands).
*/
public val Emoji.Companion.Wish: SkinTone1Emoji get() = _FoldedHands

/**
 * Alias to emoji [FoldedHands] (People & Body: hands: folded hands).
*/
public val Emoji.Companion.ThankYou: SkinTone1Emoji get() = _FoldedHands

/**
 * Alias to emoji [FoldedHands] (People & Body: hands: folded hands).
*/
public val Emoji.Companion.HighFive: SkinTone1Emoji get() = _FoldedHands
