package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SadButRelievedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😥",
        description = "sad but relieved face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sad-but-relieved-face", "concerned"),
        emoticons = listOf("•_•'"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: sad but relieved face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SadButRelievedFace: Emoji get() = _SadButRelievedFace

/**
 * Alias to emoji [SadButRelievedFace] (Smileys & Emotion: face-concerned: sad but relieved face).
*/
public val Emoji.Companion.Concerned: Emoji get() = _SadButRelievedFace
