package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ExpressionlessFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😑",
        description = "expressionless face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("expressionless-face", "expressionless"),
        emoticons = listOf("-_-"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: expressionless face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ExpressionlessFace: Emoji get() = _ExpressionlessFace

/**
 * Alias to emoji [ExpressionlessFace] (Smileys & Emotion: face-neutral-skeptical: expressionless face).
*/
public val Emoji.Companion.Expressionless: Emoji get() = _ExpressionlessFace
