package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RelievedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😌",
        description = "relieved face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("relieved-face", "relieved"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-sleepy: relieved face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RelievedFace: Emoji get() = _RelievedFace

/**
 * Alias to emoji [RelievedFace] (Smileys & Emotion: face-sleepy: relieved face).
*/
public val Emoji.Companion.Relieved: Emoji get() = _RelievedFace
