package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithHalo: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😇",
        description = "smiling face with halo",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("smiling-face-with-halo", "halo", "innocent"),
        emoticons = listOf("O:)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: smiling face with halo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithHalo: Emoji get() = _SmilingFaceWithHalo

/**
 * Alias to emoji [SmilingFaceWithHalo] (Smileys & Emotion: face-smiling: smiling face with halo).
*/
public val Emoji.Companion.Halo: Emoji get() = _SmilingFaceWithHalo

/**
 * Alias to emoji [SmilingFaceWithHalo] (Smileys & Emotion: face-smiling: smiling face with halo).
*/
public val Emoji.Companion.Innocent: Emoji get() = _SmilingFaceWithHalo
