package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BrokenHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💔",
        description = "broken heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("broken-heart", ),
        emoticons = listOf("</3"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: broken heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BrokenHeart: Emoji get() = _BrokenHeart
