package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆑",
        description = "CL button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cl-button", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: CL button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClButton: Emoji get() = _ClButton
