package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FastReverseButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏪",
        description = "fast reverse button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("fast-reverse-button", "rewind", "leftwards-double-triangles"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: fast reverse button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FastReverseButton: Emoji get() = _FastReverseButton

/**
 * Alias to emoji [FastReverseButton] (Symbols: av-symbol: fast reverse button).
*/
public val Emoji.Companion.Rewind: Emoji get() = _FastReverseButton

/**
 * Alias to emoji [FastReverseButton] (Symbols: av-symbol: fast reverse button).
*/
public val Emoji.Companion.LeftwardsDoubleTriangles: Emoji get() = _FastReverseButton
