package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔴",
        description = "red circle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("red-circle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: red circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedCircle: Emoji get() = _RedCircle
