package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EightSpokedAsterisk: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✳️",
        description = "eight-spoked asterisk",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("eight-spoked-asterisk", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: other-symbol: eight-spoked asterisk.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EightSpokedAsterisk: Emoji get() = _EightSpokedAsterisk
