package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HighVoltage: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚡",
        description = "high voltage",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("high-voltage", "electricity", "zap", "lightning"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: high voltage.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HighVoltage: Emoji get() = _HighVoltage

/**
 * Alias to emoji [HighVoltage] (Travel & Places: sky & weather: high voltage).
*/
public val Emoji.Companion.Electricity: Emoji get() = _HighVoltage

/**
 * Alias to emoji [HighVoltage] (Travel & Places: sky & weather: high voltage).
*/
public val Emoji.Companion.Zap: Emoji get() = _HighVoltage

/**
 * Alias to emoji [HighVoltage] (Travel & Places: sky & weather: high voltage).
*/
public val Emoji.Companion.Lightning: Emoji get() = _HighVoltage
