package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EightOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕗",
        description = "eight o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("eight-oclock", "eight-o-clock"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: eight o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EightOclock: Emoji get() = _EightOclock

/**
 * Alias to emoji [EightOclock] (Travel & Places: time: eight o’clock).
*/
public val Emoji.Companion.EightOClock: Emoji get() = _EightOclock
