package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllEvent() {
    add(intArrayOf(0x1f383), _JackOLantern)
    add(intArrayOf(0x2728), _Sparkles)
    add(intArrayOf(0x1f389), _PartyPopper)
    add(intArrayOf(0x1f38a), _ConfettiBall)
    add(intArrayOf(0x1f388), _Balloon)
    add(intArrayOf(0x1f380), _Ribbon)
    add(intArrayOf(0x1f381), _WrappedGift)
    add(intArrayOf(0x1f387), _Sparkler)
    add(intArrayOf(0x1f386), _Fireworks)
    add(intArrayOf(0x1f9e8), _Firecracker)
    add(intArrayOf(0x1f9e7), _RedEnvelope)
    add(intArrayOf(0x1f390), _WindChime)
    add(intArrayOf(0x1f38f), _CarpStreamer)
    add(intArrayOf(0x1f38e), _JapaneseDolls)
    add(intArrayOf(0x1f391), _MoonViewingCeremony)
    add(intArrayOf(0x1f38d), _PineDecoration)
    add(intArrayOf(0x1f38b), _TanabataTree)
    add(intArrayOf(0x1f384), _ChristmasTree)
    add(intArrayOf(0x1f397, 0xfe0f), _ReminderRibbon)
    add(intArrayOf(0x1f397), _ReminderRibbon)
    add(intArrayOf(0x1f3ab), _Ticket)
    add(intArrayOf(0x1f39f, 0xfe0f), _AdmissionTickets)
    add(intArrayOf(0x1f39f), _AdmissionTickets)
}

internal fun MutableList<Emoji>.addAllEvent() {
    add(_JackOLantern)
    add(_Sparkles)
    add(_PartyPopper)
    add(_ConfettiBall)
    add(_Balloon)
    add(_Ribbon)
    add(_WrappedGift)
    add(_Sparkler)
    add(_Fireworks)
    add(_Firecracker)
    add(_RedEnvelope)
    add(_WindChime)
    add(_CarpStreamer)
    add(_JapaneseDolls)
    add(_MoonViewingCeremony)
    add(_PineDecoration)
    add(_TanabataTree)
    add(_ChristmasTree)
    add(_ReminderRibbon)
    add(_Ticket)
    add(_AdmissionTickets)
}

/**
 * All Emoji of the Activities: event subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allEvent(): List<Emoji> =
    ArrayList<Emoji>(21).apply { addAllEvent() }
