package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMusic() {
    add(intArrayOf(0x1f3a4), _Microphone)
    add(intArrayOf(0x1f3a7), _Headphone)
    add(intArrayOf(0x1f39a, 0xfe0f), _LevelSlider)
    add(intArrayOf(0x1f39a), _LevelSlider)
    add(intArrayOf(0x1f39b, 0xfe0f), _ControlKnobs)
    add(intArrayOf(0x1f39b), _ControlKnobs)
    add(intArrayOf(0x1f399, 0xfe0f), _StudioMicrophone)
    add(intArrayOf(0x1f399), _StudioMicrophone)
    add(intArrayOf(0x1f4fb), _Radio)
    add(intArrayOf(0x1f3bc), _MusicalScore)
    add(intArrayOf(0x1f3b5), _MusicalNote)
    add(intArrayOf(0x1f3b6), _MusicalNotes)
}

internal fun MutableList<Emoji>.addAllMusic() {
    add(_Microphone)
    add(_Headphone)
    add(_LevelSlider)
    add(_ControlKnobs)
    add(_StudioMicrophone)
    add(_Radio)
    add(_MusicalScore)
    add(_MusicalNote)
    add(_MusicalNotes)
}

/**
 * All Emoji of the Objects: music subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allMusic(): List<Emoji> =
    ArrayList<Emoji>(9).apply { addAllMusic() }
