package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Megaphone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📣",
        description = "megaphone",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("megaphone", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: sound: megaphone.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Megaphone: Emoji get() = _Megaphone
