package org.kodein.emoji.people_body.hand_fingers_closed

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHandFingersClosed() {
    add(intArrayOf(0x1f44d), _ThumbsUp)
    addVariations(intArrayOf(0x1f44d, 0x0), _ThumbsUp, 1)
    add(intArrayOf(0x1f44e), _ThumbsDown)
    addVariations(intArrayOf(0x1f44e, 0x0), _ThumbsDown, 1)
    add(intArrayOf(0x1f91c), _RightFacingFist)
    addVariations(intArrayOf(0x1f91c, 0x0), _RightFacingFist, 1)
    add(intArrayOf(0x1f91b), _LeftFacingFist)
    addVariations(intArrayOf(0x1f91b, 0x0), _LeftFacingFist, 1)
    add(intArrayOf(0x270a), _RaisedFist)
    addVariations(intArrayOf(0x270a, 0x0), _RaisedFist, 1)
    add(intArrayOf(0x1f44a), _OncomingFist)
    addVariations(intArrayOf(0x1f44a, 0x0), _OncomingFist, 1)
}

internal fun MutableList<Emoji>.addAllHandFingersClosed() {
    add(_ThumbsUp)
    add(_ThumbsDown)
    add(_RightFacingFist)
    add(_LeftFacingFist)
    add(_RaisedFist)
    add(_OncomingFist)
}

/**
 * All Emoji of the People & Body: hand-fingers-closed subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allHandFingersClosed(): List<Emoji> =
    ArrayList<Emoji>(6).apply { addAllHandFingersClosed() }
