package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithRaisedEyebrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤨",
        description = "face with raised eyebrow",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("face-with-raised-eyebrow", "raised-eyebrow"),
        emoticons = listOf("(", "͝סּ", "͜ʖ͡סּ)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: face with raised eyebrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithRaisedEyebrow: Emoji get() = _FaceWithRaisedEyebrow

/**
 * Alias to emoji [FaceWithRaisedEyebrow] (Smileys & Emotion: face-neutral-skeptical: face with raised eyebrow).
*/
public val Emoji.Companion.RaisedEyebrow: Emoji get() = _FaceWithRaisedEyebrow
