package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeartExclamation: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❣️",
        description = "heart exclamation",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("heart-exclamation", "heart-exclamation-point"),
        emoticons = listOf("<3!"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: heart exclamation.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeartExclamation: Emoji get() = _HeartExclamation

/**
 * Alias to emoji [HeartExclamation] (Smileys & Emotion: heart: heart exclamation).
*/
public val Emoji.Companion.HeartExclamationPoint: Emoji get() = _HeartExclamation
