package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseReservedButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈯",
        description = "Japanese “reserved” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-reserved-button", "reserved"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “reserved” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseReservedButton: Emoji get() = _JapaneseReservedButton

/**
 * Alias to emoji [JapaneseReservedButton] (Symbols: alphanum: Japanese “reserved” button).
*/
public val Emoji.Companion.Reserved: Emoji get() = _JapaneseReservedButton
