package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RightArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "➡️",
        description = "right arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("right-arrow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: right arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RightArrow: Emoji get() = _RightArrow
