package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BrownCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟤",
        description = "brown circle",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("brown-circle", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: brown circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BrownCircle: Emoji get() = _BrownCircle
