package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap6: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "6️⃣",
        description = "keycap: 6",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-6", "six", "keycap-six"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 6.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap6: Emoji get() = _Keycap6

/**
 * Alias to emoji [Keycap6] (Symbols: keycap: keycap: 6).
*/
public val Emoji.Companion.Six: Emoji get() = _Keycap6

/**
 * Alias to emoji [Keycap6] (Symbols: keycap: keycap: 6).
*/
public val Emoji.Companion.KeycapSix: Emoji get() = _Keycap6
