package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CrossMarkButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❎",
        description = "cross mark button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cross-mark-button", "x-mark", "no-mark"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: cross mark button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CrossMarkButton: Emoji get() = _CrossMarkButton

/**
 * Alias to emoji [CrossMarkButton] (Symbols: other-symbol: cross mark button).
*/
public val Emoji.Companion.XMark: Emoji get() = _CrossMarkButton

/**
 * Alias to emoji [CrossMarkButton] (Symbols: other-symbol: cross mark button).
*/
public val Emoji.Companion.NoMark: Emoji get() = _CrossMarkButton
