package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTransportSign() {
    add(intArrayOf(0x1f3e7), _AtmSign)
    add(intArrayOf(0x1f6be), _WaterCloset)
    add(intArrayOf(0x1f6bb), _Restroom)
    add(intArrayOf(0x1f6b9), _MensRoom)
    add(intArrayOf(0x1f6ba), _WomensRoom)
    add(intArrayOf(0x267f), _WheelchairSymbol)
    add(intArrayOf(0x1f6bc), _BabySymbol)
    add(intArrayOf(0x1f6ae), _LitterInBinSign)
    add(intArrayOf(0x1f6b0), _PotableWater)
    add(intArrayOf(0x1f6c2), _PassportControl)
    add(intArrayOf(0x1f6c3), _Customs)
    add(intArrayOf(0x1f6c4), _BaggageClaim)
    add(intArrayOf(0x1f6c5), _LeftLuggage)
}

internal fun MutableList<Emoji>.addAllTransportSign() {
    add(_AtmSign)
    add(_WaterCloset)
    add(_Restroom)
    add(_MensRoom)
    add(_WomensRoom)
    add(_WheelchairSymbol)
    add(_BabySymbol)
    add(_LitterInBinSign)
    add(_PotableWater)
    add(_PassportControl)
    add(_Customs)
    add(_BaggageClaim)
    add(_LeftLuggage)
}

/**
 * All Emoji of the Symbols: transport-sign subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allTransportSign(): List<Emoji> =
    ArrayList<Emoji>(13).apply { addAllTransportSign() }
