package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Snowman: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☃️",
        description = "snowman",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("snowman", "snowman-with-snow"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: snowman.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Snowman: Emoji get() = _Snowman

/**
 * Alias to emoji [Snowman] (Travel & Places: sky & weather: snowman).
*/
public val Emoji.Companion.SnowmanWithSnow: Emoji get() = _Snowman
