package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _StopSign: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛑",
        description = "stop sign",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("stop-sign", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: stop sign.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.StopSign: Emoji get() = _StopSign
