package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ChessPawn: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♟️",
        description = "chess pawn",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("chess-pawn", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: game: chess pawn.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ChessPawn: Emoji get() = _ChessPawn
