package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGuyana: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇾",
        description = "flag: Guyana",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-guyana", "guyana-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Guyana.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGuyana: Emoji get() = _FlagGuyana

/**
 * Alias to emoji [FlagGuyana] (Flags: country-flag: flag: Guyana).
*/
public val Emoji.Companion.GuyanaFlag: Emoji get() = _FlagGuyana
