package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSriLanka: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇰",
        description = "flag: Sri Lanka",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-sri-lanka", "sri-lanka-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Sri Lanka.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSriLanka: Emoji get() = _FlagSriLanka

/**
 * Alias to emoji [FlagSriLanka] (Flags: country-flag: flag: Sri Lanka).
*/
public val Emoji.Companion.SriLankaFlag: Emoji get() = _FlagSriLanka
