package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WomansHat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👒",
        description = "woman’s hat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("womans-hat", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: woman’s hat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomansHat: Emoji get() = _WomansHat
