package org.kodein.emoji.objects.phone

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPhone() {
    add(intArrayOf(0x1f4f1), _MobilePhone)
    add(intArrayOf(0x260e, 0xfe0f), _Telephone)
    add(intArrayOf(0x260e), _Telephone)
    add(intArrayOf(0x1f4de), _TelephoneReceiver)
    add(intArrayOf(0x1f4df), _Pager)
    add(intArrayOf(0x1f4e0), _FaxMachine)
    add(intArrayOf(0x1f4f2), _MobilePhoneWithArrow)
}

internal fun MutableList<Emoji>.addAllPhone() {
    add(_MobilePhone)
    add(_Telephone)
    add(_TelephoneReceiver)
    add(_Pager)
    add(_FaxMachine)
    add(_MobilePhoneWithArrow)
}

/**
 * All Emoji of the Objects: phone subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPhone(): List<Emoji> =
    ArrayList<Emoji>(6).apply { addAllPhone() }
